/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.decorations;

import cloud.lemonslice.teastory.entity.SeatEntity;
import cloud.lemonslice.teastory.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xueluoanping.teastory.block.NormalHorizontalBlock;

public class ChairBlock
extends NormalHorizontalBlock {
    private static final VoxelShape NORTH_SHAPE;
    private static final VoxelShape EAST_SHAPE;
    private static final VoxelShape WEST_SHAPE;
    private static final VoxelShape SOUTH_SHAPE;

    public ChairBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return SOUTH_SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        double x = 0.0;
        double z = 0.0;
        switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case NORTH: {
                z = 0.25;
                break;
            }
            case SOUTH: {
                z = -0.25;
                break;
            }
            case EAST: {
                x = -0.25;
                break;
            }
            default: {
                x = 0.25;
            }
        }
        return SeatEntity.createSeat(worldIn, pos, player, 0.3, x, z);
    }

    public float m_7749_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return 1.0f;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 60;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 60;
    }

    static {
        VoxelShape north_seat = VoxelShapeHelper.createVoxelShape(1.0, 0.0, 2.0, 14.0, 8.0, 14.0);
        VoxelShape north_back = VoxelShapeHelper.createVoxelShape(1.0, 8.0, 15.0, 14.0, 13.0, 1.0);
        VoxelShape south_seat = VoxelShapeHelper.createVoxelShape(1.0, 0.0, 0.0, 14.0, 8.0, 14.0);
        VoxelShape south_back = VoxelShapeHelper.createVoxelShape(1.0, 8.0, 0.0, 14.0, 13.0, 1.0);
        VoxelShape east_seat = VoxelShapeHelper.createVoxelShape(0.0, 0.0, 1.0, 14.0, 8.0, 14.0);
        VoxelShape east_back = VoxelShapeHelper.createVoxelShape(0.0, 8.0, 1.0, 1.0, 13.0, 14.0);
        VoxelShape west_seat = VoxelShapeHelper.createVoxelShape(2.0, 0.0, 1.0, 14.0, 8.0, 14.0);
        VoxelShape west_back = VoxelShapeHelper.createVoxelShape(15.0, 8.0, 1.0, 1.0, 13.0, 14.0);
        NORTH_SHAPE = Shapes.m_83110_((VoxelShape)north_seat, (VoxelShape)north_back);
        EAST_SHAPE = Shapes.m_83110_((VoxelShape)east_seat, (VoxelShape)east_back);
        WEST_SHAPE = Shapes.m_83110_((VoxelShape)west_seat, (VoxelShape)west_back);
        SOUTH_SHAPE = Shapes.m_83110_((VoxelShape)south_seat, (VoxelShape)south_back);
    }
}

